//
//  MCBackForwardHistory.h
//  MCApplication
//
//  Created by Ali Lalani on 7/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//
// This class is designed to work with MCMainWindowController

#import <Cocoa/Cocoa.h>

@class MCHistoryItem;
@class MCMainWindowController;

@interface MCBackForwardHistory : NSObject {
	NSMutableArray *items;

	int current;
    int maximumSize;

	MCMainWindowController *ctl;
}
#pragma mark SetupAndConfiguration
- (id)initWithWindowController:(MCMainWindowController *)aCtl;

#pragma mark ItemManagement
- (MCHistoryItem *)itemAtIndex:(int)index;
- (NSInteger)indexOfItem:(MCHistoryItem *)anItem;

- (void)addItem:(MCHistoryItem *)anItem;

- (void)goBack;
- (void)goForward;

- (void)goToItem:(MCHistoryItem *)anItem;
- (BOOL)containsItem:(MCHistoryItem *)anItem;

- (MCHistoryItem *)backItem;
- (MCHistoryItem *)forwardItem;
- (MCHistoryItem *)currentItem;

- (int)backListCount;
- (int)forwardListCount;

- (NSArray *)backList;
- (NSArray *)forwardList;

#pragma mark Accessors
- (MCMainWindowController *)ctl;
- (void)setCtl:(MCMainWindowController *)aCtl;

- (NSMutableArray *)items;
- (void)setItems:(NSMutableArray *)anItems;
@end
